﻿using System;
using System.ComponentModel;
using System.Windows.Threading;

namespace ZegarWPF.ModelWidoku
{
	public class Zegar : INotifyPropertyChanged
	{
		private DateTime poprzedniCzas = DateTime.Now;

		public DateTime AktualnyCzas
		{
			get
			{
				return DateTime.Now;
			}
		}

		public event PropertyChangedEventHandler PropertyChanged;

		public void OnPropertyChanged()
		{
			if (AktualnyCzas - poprzedniCzas < TimeSpan.FromSeconds(1) && AktualnyCzas.Second == poprzedniCzas.Second)
				return;

			if (PropertyChanged != null)
				PropertyChanged(this, new PropertyChangedEventArgs("AktualnyCzas"));
		}

		private const int okresWolnegoOdświeżaniaWidokuMs = 250; //0.25s

		public Zegar()
		{
			Action<object, EventArgs> odświeżanieWidoku = (object sender, EventArgs e) => { OnPropertyChanged(); };

			DispatcherTimer timerOdświeżaniaWidoku = new DispatcherTimer();
			timerOdświeżaniaWidoku.Tick += new EventHandler(odświeżanieWidoku);
			timerOdświeżaniaWidoku.Interval = TimeSpan.FromMilliseconds(okresWolnegoOdświeżaniaWidokuMs);
			timerOdświeżaniaWidoku.Start();
			odświeżanieWidoku(this, EventArgs.Empty);
		}
	}
}
